#ifndef _DEFINED_NetWorkDLS_Database_System_Core_Header
#define _DEFINED_NetWorkDLS_Database_System_Core_Header
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define DllImport extern "C" __declspec( dllimport )

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define MAXDATASIZE      1024
#define MAXROWSPERCOLUMB 100000
#define MAXCOLUMBS       100000
#define MINROWSPERCOLUMB 1
#define MINCOLUMBS       1
#define MAXDBNAMELENGTH  255

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

struct _NDBSColumb{
    char **Row;     // Row Data              | Row[Row]    = "Row Data";
    int *Length;    // Length to row data    | Length[Row]   = 9;

    char *Name;     // Name of columb        | Name          = "Columb Name";
    int NameLength; // Length of columb name | NameLength    = 11;
    int Rows;       // Rows in this columb   | Rows          = 1255;
};

struct _NDBSTable{
    int MaxRowsPerColumb;            //- Max Rows per columb       | MaxRowsPerColumb  = 1000;

    int MaxColumbs;                  //- Max columbs               | MaxColumbs        = 100
    int Columbs;                     //- Current columbs in Table  | Columbs           = 57;

    int TableNameLength;             //- Length of table name      | TableNameLength   = 23
    char *TableName;                 //- Name of table             | TableName         = "Addresses"

    _NDBSColumb *Columb;             //- Columbs structure         | Columb[Columb Number]
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DllImport int VAddEntryByColumbPosition(struct _NDBSTable *, int, void *, int);
DllImport int VAddEntryByColumbName(struct _NDBSTable *, char *, void *, int);
DllImport int VRetreiveDataByColumbPosition(struct _NDBSTable *, int, int, void *);
DllImport int VRetreiveDataByColumbName(struct _NDBSTable *, char *, int, void *);

DllImport int ReadNDBSFile(struct _NDBSTable *, char *);
DllImport int WriteNDBSFile(struct _NDBSTable *, char *);

DllImport int InitializeTable(struct _NDBSTable *, int, int, char *, int);
DllImport int FreeTable(struct _NDBSTable *);
DllImport int AddColumb(struct _NDBSTable *, char *, int);
DllImport int DeleteEntireRow(struct _NDBSTable *, int);
DllImport int ColumbNameToColumbPosition(struct _NDBSTable *, char *);
DllImport int GetMostRows(struct _NDBSTable *);
DllImport int DeleteCellByColumbAndRowPosition(struct _NDBSTable *, int, int);
DllImport int DeleteCellByColumbNameAndRowPosition(struct _NDBSTable *, char *, int);
DllImport int AddEntryByColumbPosition(struct _NDBSTable *, int, char *, int);
DllImport int AddEntryByColumbName(struct _NDBSTable *, char *, char *, int);
DllImport int SearchRowsByColumbPosition(struct _NDBSTable *, int, char *);
DllImport int SearchRowsByColumbName(struct _NDBSTable *, char *, char *);
DllImport int RetreiveDataLengthByColumbPosition(struct _NDBSTable *, int, int);
DllImport int RetreiveDataLengthByColumbName(struct _NDBSTable *, char *, int);
DllImport int RetreiveDataByColumbPosition(struct _NDBSTable *, int, int, char *);
DllImport int RetreiveDataByColumbName(struct _NDBSTable *, char *, int, char *);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

